; ----------------------------------------------------------
; Ahk2Exe: Version- und Manifest-Infos
; ----------------------------------------------------------
;@Ahk2Exe-SetCompanyName "Ilja Palluch"
;@Ahk2Exe-SetProductName "TAGMASTER PRO Setup"
;@Ahk2Exe-SetDescription "Installer fr TAGMASTER PRO"
;@Ahk2Exe-SetFileVersion 1.0.0.0
;@Ahk2Exe-SetProductVersion 1.0.0
;@Ahk2Exe-SetOrigFilename "setup.exe"
;@Ahk2Exe-SetCopyright (c) 2025 Ilja Palluch
;@Ahk2Exe-AddResource *RT_MANIFEST %A_ScriptDir%\setup.manifest, 1
; ----------------------------------------------------------

#NoEnv
#SingleInstance Force
SetWorkingDir, %A_ScriptDir%
SendMode Input

; === KONSTANTEN ===
appName := "Snderw.exe"
sourcePath := A_ScriptDir "\bin\" appName
targetPath := A_Startup "\" appName

; === GUI Aufbau ===
Gui, +AlwaysOnTop
Gui, Add, Text,, Dieses Programm installiert Iljas Sound-Erweiterungen.`nBitte whlen Sie eine Option:
Gui, Add, Radio, vChoice Checked, Installieren oder aktualisieren
Gui, Add, Radio,, Deinstallieren
Gui, Add, Button, Default gGo, Weiter
Gui, Add, Button, gCancel, Abbrechen

; GUI anzeigen
Gui, Show,, Iljas Sound-Installer
Return

; === Schaltflchen-Funktionen ===

Go:
    Gui, Submit

    if (Choice = 1) {
        ; Installation oder Aktualisierung
        if !FileExist(sourcePath) {
            MsgBox, 16, Fehler, Die Datei %appName% wurde im Quellordner nicht gefunden!
            ExitApp
        }

        if FileExist(targetPath) {
            Process, Close, %appName%
            Sleep, 500
            FileDelete, %targetPath%
        }

        FileCopy, %sourcePath%, %targetPath%, 1
        Run, %targetPath%
        MsgBox, 64, Fertig, %appName% wurde installiert bzw. aktualisiert und gestartet.
    }
    else if (Choice = 2) {
        ; Deinstallation
        Process, Close, %appName%
        Sleep, 500
        FileDelete, %targetPath%
        MsgBox, 64, Entfernt, %appName% wurde deinstalliert und beendet.
    }

    ExitApp

Cancel:
GuiEscape:
GuiClose:
    MsgBox, 48, Abgebrochen, Der Vorgang wurde abgebrochen.
    ExitApp
